// Solr service client utilities
/* global sc */

function moduleFunction(config) {
  // Initialize $$ with provided config or default
  let $$ = config || require('./debug')({ debug: 'cache', path: module.id });

  let json = require('client/json');

  /**
   * URL encodes parameters object
   * 
   * @param {Object} params - Parameters to encode
   * @returns {string} - URL encoded string
   */
  function urlEncode(params) {
    return Object.entries(params)
      .map(function(entry) {
        return encodeURIComponent(entry[0]) + '=' + encodeURIComponent(entry[1]);
      })
      .join('&');
  }

  /**
   * Session constructor for Solr service
   * 
   * @param {Object} parms - Session parameters
   * @returns {Session} - Session instance
   */
  function Session(parms) {
    this._parms = Object.assign(
      {
        server: 'http://localhost:8981',
      },
      parms || {}
    );
    return this;
  }

  /**
   * Performs a GET request to the Solr service
   * 
   * @param {string} service - Service endpoint
   * @param {Object} _parms - Request parameters
   * @returns {Object} - Service response
   */
  Session.prototype.get = function(service, _parms) {
    let request = json(this._parms.server, {
      accept: 'application/json',
    });
    let response = request(service).get(_parms);
    $$.debug('get', service, response);
    return response;
  };

  /**
   * Performs a POST request to the Solr service
   * 
   * @param {string} service - Service endpoint
   * @param {Object} _parms - Request parameters
   * @returns {Object} - Service response
   */
  Session.prototype.post = function(service, _parms) {
    let request = json(this._parms.server, {
      accept: 'application/json',
      type: 'application/json',
    });
    let response = request(service).post(_parms);
    return response;
  };

  // Return the module functions and constructors
  return {
    urlEncode: urlEncode,
    Session: Session
  };
}

// Initialize $$ when the module is required without parameters
let moduleExports = moduleFunction();

// Export the module function and its methods
module.exports = Object.assign(moduleFunction, moduleExports);
